-- View: public.v_pdv_vd_it

-- DROP VIEW public.v_pdv_vd_it;

CREATE OR REPLACE VIEW v_pdv_vd_it
 AS
 SELECT DISTINCT pdv_vd.cd_emp,
    pdv_vd.cd_filial,
    pdv_vd.cd_vd,
    pdv_vd.cd_cx,
    pdv_vd.nr_ecf,
    pdv_vd.dt_vd,
    pdv_vd.st_vd,
    pdv_vd_it.cd_it,
    pdv_vd_it.cd_prod,
    pdv_vd_it.qt_it,
    pdv_vd_it.qt_est_ant,
    pdv_vd_it.vlr_it,
    pdv_vd_it.tx_desc,
    pdv_vd_it.st_it,
    pdv_vd_it.cd_vend,
    pdv_vd_it.vlr_pmz,
    pdv_vd_it.vlr_custo,
    pdv_vd_it.perc_aplic,
    pdv_vd_it.vlr_desc_tot_rat,
    pdv_vd_it.vlr_liq_it AS tot_it,
    pdv_vd_it.cd_trib_fc,
    pdv_vd_it.tx_icms_it,
    pdv_vd_it.tx_red_it,
    pdv_vd_it.cd_medico_rec,
    COALESCE(pdv_vd_it.nr_autorizacao_pbm, '0'::character varying) AS nr_orc_vd_link,
    pdv_vd_it.vlr_unit_pbm AS vlr_unit_farm,
    pdv_vd_it.vlr_avista_pbm AS vlr_prod_cli,
    pdv_vd_it.vlr_reembol,
    pdv_vd_it.vlr_conv_pbm AS vlr_convenio,
    pdv_vd_it.cnpj_conv,
    pdv_vd_it.qtde_ponto_fidel,
    pdv_vd_it.envio_fidel,
    pdv_vd_it.tipo_desconto,
    COALESCE(pdv_vd_it.vlr_desc_verba) AS vlr_desc_verba,
    COALESCE(pdv_vd_it.perc_desc_verba) AS perc_desc_verba,
    pdv_vd_it.qt_aut_pbm,
    pdv_vd_it.vd_operador,
    COALESCE(pdv_vd_it.cd_vend_verba) AS cd_vend_verba,
    pdv_vd.vd_troca_fidel,
    pdv_vd_it.cd_grp_comis_pdv,
    pdv_vd_it.libera_vd_conv,
    COALESCE(pdv_vd.flag_consolidado, 0) AS flag_consolidado,
    COALESCE(pdv_vd.cd_cli_pbm, 0::numeric) AS cd_cli_pbm,
    pdv_vd_it.cd_usu_cancel,
    COALESCE(pdv_vd_it.nr_protocolo_manipulado, ''::character varying) AS nr_protocolo_manipulado,
    pdv_vd_it.tipo_imposto,
    pdv_vd_it.vlr_imposto_it,
    pdv_vd_it.tx_imposto_it,
    pdv_vd_it.cd_prod_kit,
    pdv_vd_it.qt_it_kit
   FROM pdv_vd
     JOIN pdv_vd_it ON pdv_vd.cd_emp = pdv_vd_it.cd_emp AND pdv_vd.cd_filial = pdv_vd_it.cd_filial AND pdv_vd.cd_vd = pdv_vd_it.cd_vd;

